/**************************************************************************
**
** Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the Qt Installer Framework.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia.  For licensing terms and
** conditions see http://qt.digia.com/licensing.  For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights.  These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
**
** $QT_END_LICENSE$
**
**************************************************************************/

function Controller()
{
    installer.autoRejectMessageBoxes();
    installer.installationFinished.connect(function() {
        gui.clickButton(buttons.NextButton);
    })

    installer.setDefaultPageVisible(QInstaller.ComponentSelection, false);
    if (installer.isUninstaller()) {
        installer.setDefaultPageVisible(QInstaller.Introduction,false);
        installer.setDefaultPageVisible(QInstaller.LicenseCheck, false);
    }
}

Controller.prototype.LicenseAgreementPageCallback = function() {
    gui.currentPageWidget().AcceptLicenseRadioButton.setChecked(true);
    gui.clickButton(buttons.NextButton);
}

Controller.prototype.StartMenuDirectoryPageCallback = function() {
    gui.clickButton(buttons.NextButton);
}

Controller.prototype.FinishedPageCallback = function() {
    var checkBoxForm = gui.currentPageWidget().LaunchQtCreatorCheckBoxForm
    if (checkBoxForm && checkBoxForm.launchQtCreatorCheckBox) {
        checkBoxForm.launchQtCreatorCheckBox.checked = false;
    }
    gui.clickButton(buttons.FinishButton);
}

Controller.prototype.IntroductionPageCallback =function() {
    if (installer.isInstaller()){
        gui.clickButton(buttons.NextButton);
    }
}

Controller.prototype.DynamicPackageWidgetCallback =function() {
    var widget = gui.pageWidgetByObjectName("DynamicPackageWidget");
    widget.active_license_btn.click();
    gui.clickButton(buttons.NextButton);
}

Controller.prototype.DynamicCheckLicenseWidgetCallback =function() {
    var widget = gui.pageWidgetByObjectName("DynamicCheckLicenseWidget");
    widget.active_license_button.click();
    gui.clickButton(buttons.NextButton);
}

Controller.prototype.DynamicRegisterTypesCallback = function() {

    var widget = gui.pageWidgetByObjectName("DynamicRegisterTypes");

    // uncomment the following line to skip types registration
    // widget.chb_register_types.checked = false; 

    gui.clickButton(buttons.NextButton);
} 

Controller.prototype.TargetDirectoryPageCallback = function()
{
   if (installer.isInstaller()){
        var MyInstallDirectory = installer.value("TargetDir")

        // uncomment the following line and put your custom installation directory
        // MyInstallDirectory = "your/Custom/directory"

        gui.pageWidgetByObjectName("TargetDirectoryPage").TargetDirectoryLineEdit.setText(MyInstallDirectory);
        gui.clickButton(buttons.NextButton);
    }
}

Controller.prototype.ReadyForInstallationPageCallback = function()
{
    if (installer.isInstaller()){
        gui.clickButton(buttons.NextButton);
    }
}
