% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{findModel}
\alias{findModel}
\title{Run Model Selection (PK, Monolix)}
\usage{
findModel(
  project,
  library,
  requiredFilters,
  filters = NULL,
  algorithm = NULL,
  settings = NULL,
  metric_func = NULL,
  initial_func = NULL
)
}
\arguments{
\item{project}{(required) Path to the \strong{Monolix} project (\code{.mlxtran}) that already
contains the dataset and SAEM settings. Estimation settings/seed are taken
from the project.}

\item{library}{(required) Model library to use. Options: \code{"pk"} (currently supported).}

\item{requiredFilters}{(required) Named list of \strong{required} structural components:
\itemize{
\item \strong{administration}: \code{"bolus"}, \code{"infusion"}, \code{"oral"}, \code{"oralBolus"}
\item \strong{parametrization}: \code{"rate"}, \code{"clearance"}
}}

\item{filters}{(optional) Named list defining \strong{optional} structural components
to explore. For the \code{"pk"} library:
\itemize{
\item \strong{delay}: \code{"noDelay"}, \code{"lagTime"}
\item \strong{absorption}: \code{"zeroOrder"}, \code{"firstOrder"}, \code{"sigmoid"}, \code{"transitCompartments"}
\item \strong{distribution}: \code{"1compartment"}, \code{"2compartments"}, \code{"3compartments"}
\item \strong{elimination}: \code{"linear"}, \code{"MichaelisMenten"}, \code{"combined"}
\item \strong{bioavailability} (only if \code{requiredFilters$administration == "oralBolus"}):
\code{"true"}, \code{"false"}
}
If a component is omitted, \strong{all} of its options are included in the search.}

\item{algorithm}{(optional) Search algorithm. One of
\code{"ACO"}, \code{"exhaustive_search"}, \code{"decision_tree"}.
If \code{NULL}, defaults to \code{"ACO"} when \code{settings$iiv = TRUE}, otherwise \code{"decision_tree"}.}

\item{settings}{(optional) Named list of search/algorithm settings. Unless stated,
defaults are chosen adaptively (see below). Supported entries:
\itemize{
\item \strong{N}: Integer; models per iteration (ants for ACO).
Default: \code{10} (no IIV) or \code{20} (with IIV).
\item \strong{findIIV}: Logical; explore interindividual variability (IIV). Default: \code{FALSE}.
\item \strong{findError}: Logical; explore residual error model. Default: \code{FALSE}.
\item \strong{seed}: Integer; RNG seed for reproducibility. Default: \code{123456}.
\item \strong{previous_runs}: Optional path to a CSV of past runs to warm-start/learn from. Default: \code{NULL}.
\item \strong{output}: Optional CSV path; if provided, results are appended incrementally. Default: \code{NULL}.
\item \strong{initial_iiv_forced_iter} (ACO): Integer; number of initial iterations
where IIV is forced on all parameters to encourage exploration. Default: \code{3}.
\item \strong{rho} (ACO): Learning/evaporation rate. Default: \code{0.4}.
\item \strong{obsIDToUse}: Character/integer; which observation ID to use (required if the project has multiple).
\item \strong{plot}: Logical; if \code{TRUE} and optional deps are available, render progress
(DiagrammeR/data.tree for Decision Tree; plotly/htmltools for ACO). Default: \code{TRUE}.
\item \strong{linearization}: Logical; if \code{TRUE}, use linearization for log-likelihood in the default metric.
Default: \code{FALSE}.
\item \strong{save_mode}: How to persist Monolix runs during training. One of:
\itemize{
\item \code{"none"}: do not save runs
\item \code{"best"} (default): save only the current best-performing run
\item \code{"all"}: save every run
}
Models (if saved) are written under \code{autoBuild/} in the project's result directory.
\item \strong{clip}: Logical; clip sampling probabilities during stochastic search. Default: \code{FALSE}.
\item \strong{keys}: Character vector; internal ordering of structural “keys” to update
during decision tree (auto-derived from administration).
\item \strong{elitism}: Logical; keep the current best candidate across iterations (ACO).
Default: \code{TRUE}.
\item \strong{max_models}: Integer cap on the total number of models to evaluate. Default: \code{1e6}.
\item \strong{iiv_favor_true}: Logical; bias exploration toward keeping IIV Default: \code{FALSE}.
\item \strong{xgboost}: Logical; enable XGBoost-based guidance for ACO. Default: \code{TRUE}.
\item \strong{xgboost_model_nb}: Integer; number of boosting models to maintain if \code{xgboost = TRUE}. Default: \code{5}.
\item \strong{table_func}: function that allows you to output additional information about each run. See online doc for more information.
}}

\item{metric_func}{(optional) \strong{Zero-argument} function that returns a single numeric
score for the \strong{last run model} (lower is better). Use \code{lixoftConnectors} inside
the function to read results (e.g., information criteria). \strong{Default}:
\emph{BICc} when \code{settings$iiv = FALSE}; \emph{BICc + penalty} when \code{settings$iiv = TRUE},
where the penalty is \code{count(RSE > 50\%) * log(n_observations)}. This default was chosen
after thorough testing for robustness and precision.}

\item{initial_func}{(optional) Function that \strong{takes one argument} (the \code{project}
path) and \strong{returns a project path} (same or new) after setting initial values via
\code{lixoftConnectors}. Use this to inject custom population initials before each run.
If \code{NULL}, the package uses its internal/default initializer.}
}
\value{
A list that contains:
\itemize{
\item \strong{results}: a data frame where each row corresponds to a tested model, including:
structural choices, IIV/error settings, metric value,
\item \strong{best_model}: a data frame with one row corresponding to the best model,
\item \strong{best_path}: path to the saved Monolix runs corresponding to the best model (if save_mode is \code{all} or \code{best}),
\item \strong{iteration_progress}: progress per iteration for ACO,
\item \strong{prob_history}: list of sampling probabilities at the end of each iteration for ACO.
}
}
\description{
Automates structural model selection for PK models in Monolix via
\code{lixoftConnectors}. The function constructs a search space from
\code{requiredFilters} (route/parametrization) and optional \code{filters}
(absorption, delay, distribution, elimination, bioavailability), then
explores that space using a chosen algorithm and returns a tidy data frame
of all tested models with their performance metrics and run metadata.
}
\details{
If \code{algorithm} is not provided, it is selected automatically:
\strong{"ACO"} when searching for IIV (\code{settings$iiv = TRUE}), otherwise
\strong{"decision_tree"}.

The function initializes \code{lixoftConnectors}, loads the provided project, validates inputs,
constructs the search space from \code{requiredFilters} + \code{filters}, and then runs the selected
algorithm. Progress and diagrams are only plotted if \code{settings$plot = TRUE} and the relevant
suggested packages are installed.
}
\examples{
\dontrun{
# Example 1: Default search with oral clearance models and additional filters
res <- findModel(
  project = file.path(getDemoPath(), "1.creating_and_using_models",
                      "1.1.libraries_of_models", "theophylline_project.mlxtran"),
  library = "pk",
  requiredFilters = list(administration = "oral", parametrization = "clearance"),
  filters = list(absorption = c("zeroOrder", "firstOrder"), elimination = "linear"),
  settings = list(findIIV = FALSE, findError = TRUE)
)

# Example 2: Oral bolus rate-parametrized models on an IV/Oral project w/o plotting progress
res <- findModel(
  project = file.path(getDemoPath(), "6.PK_models", "6.2.multiple_routes",
                      "ivOral1_project.mlxtran"),
  library = "pk",
  requiredFilters = list(administration = "oralBolus", parametrization = "rate"),
  filters = list(absorption = c("zeroOrder", "firstOrder"),
                 elimination = "linear", bioavailability = "true"),
  settings = list(findIIV = FALSE, findError = FALSE, plot = FALSE)
)

# Example 3: Bolus route with IIV and residual error estimation, saving progress
res <- findModel(
  project = file.path(getDemoPath(), "6.PK_models", "6.1.single_route",
                      "bolusMixed_project.mlxtran"),
  library = "pk",
  requiredFilters = list(administration = "bolus", parametrization = "rate"),
  settings = list(findIIV = TRUE, findError = TRUE, output = "list_of_runs.csv")
)

# Example 4: Exhaustive search over oral clearance models
res <- findModel(
  project = file.path(getDemoPath(), "1.creating_and_using_models",
                      "1.1.libraries_of_models", "theophylline_project.mlxtran"),
  library = "pk",
  requiredFilters = list(administration = "oral", parametrization = "clearance"),
  algorithm = "exhaustive_search"
)

# Example 5: Decision tree search strategy even though searching for IIV
res <- findModel(
  project = file.path(getDemoPath(), "1.creating_and_using_models",
                      "1.1.libraries_of_models", "theophylline_project.mlxtran"),
  library = "pk",
  requiredFilters = list(administration = "oral", parametrization = "clearance"),
  algorithm = "decision_tree",
  settings = list(findIIV = TRUE)
)
}

}
