% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initial_values.R
\name{applyInitials}
\alias{applyInitials}
\title{Create a Function to Apply Initial Parameter Estimates}
\usage{
applyInitials(init_list, save_as_copy = TRUE)
}
\arguments{
\item{init_list}{A named list or numeric vector. Names should correspond to
individual parameter names (e.g., "ka") or population parameter names
(e.g., "ka_pop"). The values are the initial estimates to be set.}

\item{save_as_copy}{Logical. If \code{TRUE} (the default), the modified project is
saved as a copy in a temporary directory with an "_init" suffix. If \code{FALSE},
the original project file is overwritten.}
}
\value{
Returns a new function that takes a single argument, \code{path}, which is
the file path to a Monolix (\code{.mlxtran}) project. This returned function
modifies the project with the specified initial estimates and returns the
path to the saved project file.
}
\description{
A factory function that generates a new function to apply a list of
initial parameter estimates to a Monolix project file.
}
\details{
The function created by \code{applyInitials} performs the following steps:
\enumerate{
\item Loads the Monolix project specified by \code{path}.
\item Maps the names from \code{init_list} to the project's population parameter
names. It automatically appends "_pop" to names that match individual
parameter names (e.g., "ka" becomes "ka_pop").
\item Updates the 'initialValue' for the matched population parameters.
\item Saves the project, either as a copy or by overwriting the original,
based on the \code{save_as_copy} argument.
\item Returns the file path of the saved project.
}
This factory is useful for creating reusable functions to test different
sets of initial estimates in a modeling workflow.
}
\examples{
\dontrun{
# Define a list of initial estimates
my_inits <- list(ka = 2.5, V = 10, Cl = 0.5)

# Create a function that will apply these estimates and save as a copy
res <- findModel(
  project = "theophylline_project.mlxtran",
  library = "pk",
  requiredFilters = list(administration = "oral", parametrization = "clearance"),
  filters = list(distribution = c("1compartment", "2compartments"),
                 absorption = "firstOrder",
                 elimination = "linear"),
  initial_func = applyInitials(my_inits, save_as_copy = TRUE)
  )
}
}
